package cn.com.duiba.odps.center.api.remoteservice.unionpay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.unionpay.DlUnionPayConsumptionDailyDataDto;
import cn.com.duiba.odps.center.api.dto.unionpay.DlUnionpayAbnormalUserDailyDataDiDto;
import cn.com.duiba.odps.center.api.dto.unionpay.MerchantsAndUserDataDto;
import cn.com.duiba.odps.center.api.dto.unionpay.WeekConsumptionDataDto;

import java.util.Date;
import java.util.List;

/**
 * 大连银联数据看板
 * @author chenzhenxing
 * @date 2022/1/9 6:32 下午
 */
@AdvancedFeignClient
public interface RemoteDlUnionPayDataCheckService {
    List<DlUnionPayConsumptionDailyDataDto> getConsumptionDailyDataByDate(Date startDate,Date endDate,String tradeType);
    List<DlUnionpayAbnormalUserDailyDataDiDto> getAbnormalUserDailyDataByDate(Date startDate, Date endDate);
    /**
     * 周消费数据
     * @param startDate
     * @param endDate
     * @return
     */
    WeekConsumptionDataDto getWeekConsumption(Date startDate, Date endDate);

    /**
     * 获取消费金额top20商户并返回各交易类型总金额明细
     * @param startDate
     * @param endDate
     * @return
     */
    List<DlUnionPayConsumptionDailyDataDto> getTop20AmountForTradeType(Date startDate, Date endDate);

    /**
     * 获取消费数top20商户并返回各交易类型总消费数明细
     * @param startDate
     * @param endDate
     * @return
     */
    List<DlUnionPayConsumptionDailyDataDto> getTop20NumsForTradeType(Date startDate, Date endDate);

    /**
     * 获取商户和用户维度数据
     * @param startDate
     * @param endDate
     * @return
     */
    MerchantsAndUserDataDto getMerchantsAndUserData(Date startDate, Date endDate);
}
