package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.ForumAnnouncementDailyDataDto;
import cn.com.duiba.odps.center.api.dto.ForumAnnouncementDataDto;
import cn.com.duiba.odps.center.api.dto.ForumAnnouncementExposeDataDto;
import cn.com.duiba.odps.center.api.dto.ForumAnnouncementVisitDataDto;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteForumAnnouncementDataService {

    List<ForumAnnouncementExposeDataDto> selectExposeDataByArticleId(Long articleId);

    List<ForumAnnouncementVisitDataDto> selectVisitDataByArticleId(Long articleId);

    List<ForumAnnouncementDailyDataDto> selectDailyDataByArticleId(Long articleId, Date start, Date end);

    ForumAnnouncementDataDto selectDataByArticleId(Long articleId, Date start, Date end);
}
