package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * OTO客户信息表
 * @author kjj mybatis generator 
 * @date 2022-01-10
 */
@Data
public class OtoCustomerDto implements Serializable {
     
    private static final long serialVersionUID = 16417939475489692L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 表单记录id tb_pub_form_record.id
     */
    private Long formRecordId;

    /**
     * 手机号码
     */
    private String phoneNum;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户所在省市区
     */
    private String custArea;

    /**
     * 客户出生年份
     */
    private String custBirthYear;

    /**
     * 出生年月日
     */
    private Date birthdayTime;

    /**
     * 客户备注
     */
    private String custDescription;

    /**
     * 分配状态,0-待分配，1-已分配
     * {@link cn.com.duiba.oto.enums.cust.OtoCustAssignStatusEnum}
     */
    private Integer assignStatus;

    /**
     * 客户价值 1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     *
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 系统评定的客户价值 1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private Integer systemCustValue;

    /**
     * 是否星标客户
     */
    private Integer custStar;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 客户所属保险公司id,tb_oto_company.id
     */
    private Long custCompany;

    /**
     * 客户所处资源池类型
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private Integer poolType;

    /**
     * 进入资源池时间
     */
    private Date poolTime;

    /**
     * 客户等级
     * @see cn.com.duiba.oto.enums.cust.OtoCustLevelEnum
     */
    private Integer custLevel;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustSourceEnum
     */
    private Integer custSource;

    /**
     * 自建客户的创建人
     */
    private String createName;

    /**
     * 流程组状态
     * @see cn.com.duiba.oto.enums.cust.CustFlowEnum
     */
    private Integer custFlow;

    /**
     * 历史跟进人销售id（用,隔开）
     */
    private String historyFollower;

    /**
     * 客户地址
     */
    private String custAddress;

    /**
     * 客户性别
     * @see cn.com.duiba.oto.enums.cust.CustGenderEnum
     */
    private Integer custGender;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSource;

    /**
     * 客户行为类型
     * @see cn.com.duiba.oto.enums.cust.CustActionTypeEnum
     */
    private String custActionType;

    /**
     * 客户系数
     */
    private Integer custCoefficient;

    /**
     * 客户地区
     *
     * @see cn.com.duiba.oto.enums.cust.CustRegionEnum
     */
    private Integer custRegion;


    private Long introducerId;

    private Long otoSid;

    /**
     * 是否需要记录opt日志
     */
    private Boolean optFlag = false;
}