package cn.com.duiba.oto.oto.service.api.remoteservice.conversation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.conversation.WxWorkListParam;
import cn.com.duiba.oto.param.oto.conversation.WxWorkMsgDetailListParam;
import cn.com.duiba.oto.param.oto.conversation.WxWorkMsgGroupListParam;
import cn.com.duiba.oto.param.oto.conversation.WxWorkMsgListParam;
import cn.com.duiba.oto.vo.WxWorkChatVO;
import cn.com.duiba.oto.vo.WxWorkListVO;
import cn.com.duiba.oto.vo.WxWorkMsgListVO;
import cn.com.duiba.oto.vo.WxWorkPageVO;

import java.util.List;


/**
 * @author liuyajun
 * @date 2022/03/24
 */
@AdvancedFeignClient
public interface RemoteWxWorkConversationService {

    /**
     * 查询左侧会话列表
     * @param param
     * @return
     */
    WxWorkPageVO<WxWorkListVO> selectCharList(WxWorkListParam param);

    /**
     * 查询中间会话列表
     * @param param
     * @return
     */
    WxWorkChatVO<WxWorkMsgListVO> msgList(WxWorkMsgListParam param);

    /**
     * 查询上下15条聊天记录
     */
    List<WxWorkMsgListVO> msgDetailList(WxWorkMsgDetailListParam param);


    /**
     * 查询左侧会话列表（云客）
     *
     * @param param
     * @return
     */
    WxWorkPageVO<WxWorkListVO> selectCharListYunke(WxWorkListParam param);

    /**
     * 查询中间会话列表（云客）
     *
     * @param param
     * @return
     */
    WxWorkChatVO<WxWorkMsgListVO> msgListYunke(WxWorkMsgListParam param);

    /**
     * 查询上下15条聊天记录（云客）
     */
    List<WxWorkMsgListVO> msgDetailListYunke(WxWorkMsgDetailListParam param);

}
