package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustFollowCommentDto;
import cn.com.duiba.oto.dto.oto.cust.CustFollowDto;
import cn.com.duiba.oto.dto.oto.cust.OtoCustClassifyCountDto;
import cn.com.duiba.oto.dto.oto.cust.OtoCustFollowCountDto;
import cn.com.duiba.oto.param.oto.cust.OtoFollowWeightUpdateParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-08 14:55
 * 客户跟进机会service
 */
@AdvancedFeignClient
public interface RemoteOtoCustFollowService {

    /**
     * 新增
     * @param dto 客户跟进记录
     * @return 执行结果
     */
    boolean insert(CustFollowDto dto);

    /**
     * 更新
     * @param dto 客户跟进记录
     * @return 执行结果
     */
    boolean update(CustFollowDto dto);

    /**
     * 客户跟进信息
     * @param custId 客户id
     * @return 客户跟进信息
     */
    CustFollowDto findByCustId(Long custId);

    /**
     * 根据客户id批量查询客户跟进信息
     *
     * @param custIds 客户id
     * @return 客户跟进信息
     */
    List<CustFollowDto> listByCustIds(List<Long> custIds);

    /**
     * 获取关注度及其评论
     * @param custId 客户id
     * @return 关注度及其评论
     */
    CustFollowCommentDto findFollowWeightComment(Long custId);

    /**
     * 根据客户分类统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustClassifyCountDto> countByCustClassify(Long otoSid);

    /**
     * 根据客户跟进状态统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustFollowCountDto> countByFollowStatus(Long otoSid);

    /**
     * 根据客户信息修改跟进状态
     *
     * @param custId 客户id
     * @param otoSid 销售id
     */
    void updateFollowStatus(Long custId, Long otoSid) throws BizException;

    /**
     * 根据客户信息修改客户分类
     *
     * @param custId 客户id
     * @param otoSid 销售id
     */
    void updateFollowClassify(Long custId, Long otoSid) throws BizException;

    /**
     * 修改客户关注度
     * @param param 修改客户关注度
     * @return 修改结果
     */
    boolean updateFollowWeight(OtoFollowWeightUpdateParam param);

    /**
     * 批量更新跟进客户权重(刷数据专用)
     *
     * @param custIds      客户id集合
     * @param followWeight 关注度
     * @return 修改结果
     */
    boolean batchUpdateFollowWeight(List<Long> custIds, Integer followWeight);

    /**
     * 批量更新跟进客户权重(刷数据专用)
     *
     * @param custIds      客户id集合
     * @param time 次数
     * @return 修改结果
     */
    boolean batchUpdateFollowTimes(List<Long> custIds, Integer time);

    /**
     * 清除客户权重
     */
    boolean clearFollowWeight(Long custId);

    /**
     * 为客户分配或重新分配销售
     *
     * @param sellerId   销售id
     * @param custId     客户id
     * @param assignType 分配类型 {@link cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum}
     * @return 分配结果
     */
    boolean assign(Long sellerId, Long custId, Integer assignType);

    /**
     * 根据销售ID查询新客户
     * @param sellerId 销售ID custIds 客户ID
     * @return 结果集
     */
    List<CustFollowDto> listBySellerId(Long sellerId, List<Long> custIds);

    /**
     * 获取成员跟进中的客户列表
     * @param sellerId
     * @return
     */
    List<CustFollowDto> listBySid(Long sellerId);

    /**
     * 分页获取数据
     * @param lastId
     * @return
     */
    List<CustFollowDto> pageForSync(Long lastId);
}
