package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.SellerNotifyDto;
import cn.com.duiba.oto.param.oto.seller.SellerNotifyParam;

import java.util.List;

/**
 * OTO销售通知
 * @author chenzhenxing
 * @date 2022/3/27 5:32 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerNotifyService {

    /**
     * 新增通知
     * @param param 通知信息
     * @return 新增结果
     */
    boolean save(SellerNotifyParam param);

    /**
     * 根据客户id和销售id以及通知类型更新通知状态
     * @param param 通知信息
     * @return 更新结果
     */
    boolean modifyNotifyStatus(SellerNotifyParam param);

    /**
     * 根据客户id获取日程信息
     * @param sellerId 销售id
     * @param custId 客户id
     * @return 日程信息
     */
    List<SellerNotifyDto> getScheduleBySellerIdAndCustId(Long sellerId, Long custId);

    /**
     * 根据客户id和销售id删除日程
     * @param sellerId 销售id
     * @param custId 客户id
     * @return 删除结果
     */
    boolean removeScheduleBySellerIdAndCustId(Long sellerId, Long custId);

    /**
     * 根据销售id查询当天通知
     * @param sellerId 销售id
     * @return 通知列表
     */
    List<SellerNotifyDto> getCurDateNoticesBySellerId(Long sellerId);

}
