package cn.com.duiba.oto.param.oto.pubform;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author chenzhenxing
 * @date 2022/3/11 9:30 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PubFormRecordQueryListParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 3238719166247286532L;

    /**
     * 表单id
     */
    private Long formId;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     *  标签 -1=其他 0=暂无 1=有效 2=无效
     *  @see cn.com.duiba.oto.enums.form.RecordLabelEnum
     */
    private Integer recordLabel;

    /**
     * 客户等级
     * @see cn.com.duiba.oto.enums.cust.OtoCustLevelEnum
     */
    private Integer custLevel;
}
