package cn.com.duiba.oto.oto.service.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.OtoTagDto;

import java.util.List;

/**
 * OTO-标签
 *
 * @author ZhangJun
 * @date 2022/1/7 10:57 上午
 */
@AdvancedFeignClient
public interface RemoteOtoTagService {

    /**
     * 获取标签总数量
     *
     * @return 标签总数
     */
    Long count();

    /**
     * 分页查询
     *
     * @param offset   分页偏移量
     * @param pageSize 分页大小
     * @return 查询结果
     */
    List<OtoTagDto> pageList(Integer offset, Integer pageSize);

    /**
     * 根据标签名查询标签
     *
     * @param tagName 标签名称
     * @return 查询到的标签信息
     */
    OtoTagDto findByTagName(String tagName);

    /**
     * 批量根据标签名查询标签
     *
     * @param tagNames 标签名称
     * @return 标签信息
     */
    List<OtoTagDto> listByTagNames(List<String> tagNames);

    /**
     * 查询客户对应的标签详情
     * @param custId 客户id
     * @return
     */
    List<OtoTagDto> listEnableByCustId(Long custId);

    /**
     * 保存标签
     *
     * @param dto 标签信息
     * @return 保存结果
     */
    OtoTagDto save(OtoTagDto dto);

    /**
     * 编辑标签名称
     *
     * @param id      标签id
     * @param tagName 标签名称
     * @return 编辑结果
     */
    boolean updateTagName(Long id, String tagName);

    /**
     * 修改标签状态
     *
     * @param id        标签id
     * @param tagStatus 标签状态
     * @return 修改结果
     */
    boolean switchTagStatus(Long id, Integer tagStatus);

    /**
     * 删除标签
     *
     * @param id 标签id
     * @return 删除结果
     */
    boolean delete(Long id);

    /**
     * 查询状态为启用的标签
     * @return 标签
     */
    List<OtoTagDto> listEnableTags();

    /**
     * 根据标签ID查询
     * @param tagIds 标签ID
     */
    List<OtoTagDto> listByTagIds(List<Long> tagIds);
}
