package cn.com.duiba.oto.dto.oto.wxwork;

import cn.com.duiba.oto.vo.WxWorkListVO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liuyj
 * @date 2022/10/18 16:02
 */
@Data
public class AggregationGroupEsBean implements Serializable {
    /**
     * 获取hits字段
     */
    private static final String HIST = "hits";
    /**
     * 获取hits中的source字段
     */
    private static final String SOURCE = "_source";
    /**
     * 获取聚合查询结果的字段
     */
    private static final String AGGREGATIONS = "aggregations";
    /**
     * 获取聚合查询结果字段中的关键字字段
     */
    private static final String BUCKETS = "buckets";
    /**
     * 获取聚合查询结果字段中的关键字字段中的值
     */
    private static final String KEY = "key";
    private static final String DOC_COUNT = "doc_count";
    /**
     * 获取聚合查询metric类型结果的值
     */
    private static final String VALUE = "value";

    private int i = 1;

    /**
     * "探索"ES的aggregations
     * @param resultOverList 提前准备好存放最终数据的集合 (引用传递)
     * @param keyMap 还可以继续进行解析的数据
     * @param resultMap 前面拿到的数据信息
     */
    public void bucketsAnalysis(List<Map<String, Object>> resultOverList, Map.Entry<String, Object> keyMap, Map<String, Object> resultMap) {
        Map<String, Object> valueMap = (Map<String, Object>) keyMap.getValue();
        if (null == valueMap.get(BUCKETS)) {
            //找不到buckets关键字，就只拿value关键字
            resultMap.put(keyMap.getKey(), valueMap.get(VALUE));
            Map<String, Object> overMap = new TreeMap<>(resultMap);
            resultOverList.add(overMap);
            return;
        }

        //拿到第一层buckets
        List<Map<String, Object>> bucketsList = (List<Map<String, Object>>) valueMap.get(BUCKETS);
        for (Map<String, Object> buckets : bucketsList) {
            resultMap.put(keyMap.getKey(), buckets.get(KEY));

            resultMap.put(DOC_COUNT, buckets.get(DOC_COUNT));


            if (buckets.size() <= 2) {
                Map<String, Object> overMap = new TreeMap<>(resultMap);
                resultOverList.add(overMap);
                continue;
            }
            for (Map.Entry<String, Object> map : buckets.entrySet()){
                try {
                    Map<String, Object> testMap = (Map<String, Object>) map.getValue();
                    //*****************************************
                    //在这里又调用了一次当前方法, 去探索其内部结构
                    //*****************************************
                    bucketsAnalysis(resultOverList, map, resultMap);
                    break;
                } catch (Exception e) {
                }
            }
        }
    }

    /**
     * 解析ES原生的返回结果
     * @param resultEsMap ES原生的JSON格式返回结果
     * @return 返回最终解析后的数据
     */
    public List<Map<String, Object>> convertResult(Map<String, Object> resultEsMap) {
        List<Map<String, Object>> resultOverList = new LinkedList<>();
        if (null == resultEsMap || resultEsMap.isEmpty()) {
            return resultOverList;
        }
        Map<String, Object> hitsMap = (Map)resultEsMap.get(HIST);
        List<Map<String, Object>> hitsList = (List) hitsMap.get(HIST);
        //找不到就是聚合，否则普通
        if (null == hitsList || hitsList.isEmpty()) {
            Map<String, Object> aggregationsMap = (Map)resultEsMap.get(AGGREGATIONS);
            for (Map.Entry<String, Object> keyMap : aggregationsMap.entrySet()){
                Map<String, Object> valueMap = (Map<String, Object>) keyMap.getValue();
                Map<String, Object> resultMap = new TreeMap<>();
                if (null == valueMap.get(BUCKETS)) {
                    //找不到buckets关键字，就只拿value关键字
                    resultMap.put(keyMap.getKey(), valueMap.get(VALUE));
                    resultOverList.add(resultMap);
                    return resultOverList;
                }
                bucketsAnalysis(resultOverList,keyMap,resultMap);
            }
            return resultOverList;
        }else {

            Map<String, Object> aggregationsMap = (Map)resultEsMap.get(AGGREGATIONS);
            for (Map.Entry<String, Object> keyMap : aggregationsMap.entrySet()){
                Map<String, Object> valueMap = (Map<String, Object>) keyMap.getValue();
                Map<String, Object> resultMap = new TreeMap<>();
                if (null == valueMap.get(BUCKETS)) {
                    //找不到buckets关键字，就只拿value关键字
                    resultMap.put(keyMap.getKey(), valueMap.get(VALUE));
                    resultOverList.add(resultMap);
                    return resultOverList;
                }
                bucketsAnalysis(resultOverList,keyMap,resultMap);
            }
            return resultOverList;
        }
    }


}
