package cn.com.duiba.oto.oto.service.api.remoteservice.audit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.audit.OtoAuditDto;
import cn.com.duiba.oto.param.oto.audit.OtoAuditSearchParam;
import cn.com.duiba.oto.param.oto.audit.OtoAuditUpdateParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/5/31 13:57
 */
@AdvancedFeignClient
public interface RemoteAuditService {
    /**
     * 保存/提交入职信息
     * @param param 保存/提交 参数
     */
    OtoAuditDto save(OtoAuditSearchParam param);

    /**
     * 查询审批列表
     * @param param 查询参数
     */
    List<OtoAuditDto> list(OtoAuditSearchParam param);

    /**
     * 查询审批记录
     * @param id 查询参数
     */
    OtoAuditDto selectById(Long id);

    /**
     * 编辑
     * @param param 编辑 参数
     */
    void update(OtoAuditSearchParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return 查询总条数
     */
    Long pageCount(OtoAuditSearchParam param);

    /**
     * 批量更新biz_model
     */
    void batchUpdateAudit(OtoAuditUpdateParam param);
}
