package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoSellerCustRefDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-10 13:44
 * 客户 rpc service
 */
@AdvancedFeignClient
public interface RemoteOtoSellerCustRefService {

    /**
     * 根据客户id查询客户信息
     *
     * @return 客户信息
     */
    boolean save(OtoSellerCustRefDto otoSellerCustRefDto);

    /**
     * 根据客户id批量查询客户信息
     *
     * @param custIds 客户id
     * @return 客户信息
     */
    List<OtoSellerCustRefDto> findBySellerAndCustIds(Long sellerId, List<Long> custIds);
}
