package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCheckStrategyDto;
import cn.com.duiba.oto.dto.oto.cust.OtoStrategyTeamRefDto;
import cn.com.duiba.oto.param.oto.cust.OtoCheckStrategyParam;
import cn.com.duiba.oto.param.oto.cust.OtoCheckStrategySearchParam;
import cn.com.duiba.oto.param.oto.cust.OtoStrategyTeamRefParam;
import cn.com.duiba.oto.param.oto.cust.OtoStrategyTeamRefSearchParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoStrategyTeamRefService {

    /**
     * 查询策略配置关联团队
     * @param param 查询条件
     */
    List<OtoStrategyTeamRefDto> list(OtoStrategyTeamRefSearchParam param);

    /**
     * 新增关联策略配置
     * @param params 参数
     * @return
     */
    boolean batchSave(List<OtoStrategyTeamRefParam> params);

    /**
     * 修改关联策略配置
     * @param ids
     */
    boolean batchDeleteByStrategyIds(List<Long> ids);

}
