package cn.com.duiba.oto.param.oto.interview;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 面访授权评价详情
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InterviewAuthorizeEvaluateParam implements Serializable {

    private static final long serialVersionUID = 2643952600552454873L;

    /**
     * 扫码用户id
     */
    private Long scanUserId;


    /**
     * 面访码ID
     */
    private Long interviewId;

    /**
     * 小程序码id
     */
    private Long scanCodeId;

    /**
     * 评价详情
     * @see cn.com.duiba.oto.enums.interview.EvaluateDetailEnum
     */
    private List<Integer> evaluateDetail;
}
