package cn.com.duiba.oto.param.oto.interview;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 移动端面访列表查询
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OtoQueryInterviewRecordParam implements Serializable {

    private static final long serialVersionUID = -8821094918086963878L;

    /**
     * 面访类型
     *
     * @see cn.com.duiba.oto.enums.interview.InterviewTypeEnum
     */
    private Integer interviewType;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 是否完成 0进行中 1已完成 2审批中 3已失效
     */
    private Integer isFinish;


    /**
     * 最后一条记录ID
     */
    private Long lastId;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 面访状态
     */
    private List<Integer> interviewStatus;

    /**
     * 见面目的 1-1进2，2-2进3/2进4，3-3进，0-关系维护维护
     */
    private List<Integer> custPhases;

    /**
     * 面访场景配置ID 【tb_cust_interview_conf】
     */
    private List<Long> interviewConfIds;
}
