package cn.com.duiba.oto.param.oto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * oto-销售任务配置修改参数
 *
 * @author chenzhenxing
 * @date 2022/4/25 2:16 下午
 */
@Data
public class SellerTaskConfV2Param implements Serializable {
    private static final long serialVersionUID = -8271612729493406384L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务类型：1:承接客户，2:未接通客户，3:拒绝客户，4:当日需再次跟进客户，5:到场待确认客户，6:鸽子客户，7:退回客户
     */
    private Integer taskType;

    /**
     * 客户类型：1:全部客户、2:新客户、3:老客户
     */
    private Integer custType;

    /**
     * 非客户来源：多个用逗号分隔
     */
    private List<String> notCustSource;

    /**
     * 可见角色：多个用逗号分隔
     */
    private List<Integer> sellerRole;

    /**
     * 基准时间
     */
    private String baseTime;

    /**
     * 生效天数：多个用逗号分隔(用当前日期-基准日期 去生成任务)
     */
    private List<Integer> effectDays;

    /**
     * 任务是否启用状态： 0-否  1-是
     */
    private Integer taskUsable;

}
