package cn.com.duiba.oto.dto.oto.dept;

import cn.com.duiba.oto.util.PageResult;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：部门列表对象
 *
 * @Auther: xiaotian
 * @Date: 2023/2/8 15:38
 * @Description:
 */
@Data
public class DeptSellerDto implements Serializable {
    private static final long serialVersionUID = 8825633410129189285L;

    /**
     * 部门id
     */
    private Long deptId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 是否根部门
     */
    private Boolean isRoot = false;

    /**
     * 分页销售列表
     */
    private PageResult<DeptSellerListDto> page;


    @Data
    public static class DeptSellerListDto implements Serializable {

        private static final long serialVersionUID = -1204463105918970801L;
        /**
         * 销售id
         */
        private Long sellerId;

        /**
         * 销售名称
         */
        private String sellerName;

        /**
         * 角色
         */
        private List<String> roles;

        /**
         * 手机号
         */
        private String phone;

        /**
         * 部门列表
         */
        private List<String> depts;
    }
}
