package cn.com.duiba.oto.dto.oto.interview;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liuyj
 * @date 2022/8/31 20:05
 */
@Data
public class OtoCustInterviewExtDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     *  面访记录表【tb_cust_interview_record】
     */
    private Long interviewId;

    /**
     * 面访场景配置ID 【tb_cust_interview_conf】
     */
    private Long interviewConfId;

    /**
     * 见面目的 1-1进2，2-2进3/2进4，3-3进，0-关系维护维护
     */
    private Integer custPhase;

    /**
     * 客户觉得退休后到底要准备多少退休金才够用
     */
    private Integer pensionSalary;

    /**
     * 希望退休后每个月的养老生活费是多少
     */
    private Integer pensionCost;

    /**
     * 除了退休养老规划，还希望了解的有关家庭财富的板块有哪些
     */
    private String pensionOther;

    /**
     * 是否提交养老计划方案 0:否 1：是
     */
    private Integer commitPlanFlag;

    /**
     * 计划书图片
     */
    private String planPicUrl;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     */
    private Integer commitCustStatus;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品ID tb_product
     */
    private Long productId;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     */
    private Integer insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数 0默认为趸交
     */
    private Integer insPeriod;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
