package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO-标签状态枚举
 *
 * @author ZhangJun
 * @date 2022/1/7 11:15 上午
 */
@Getter
@AllArgsConstructor
public enum OtoTagStatusEnum {

    /**
     * 标签处于关闭状态，不可见，不可打标签
     */
    CLOSE(0, "关闭"),

    /**
     * 标签开启
     */
    OPEN(1, "开启"),
    ;

    private Integer tagStatus;
    private String desc;
    
    private static final Map<Integer, OtoTagStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoTagStatusEnum::getTagStatus, Function.identity(), (v1, v2) -> v1)));

    public static OtoTagStatusEnum getByTagStatus(Integer tagStatus) {
        if (Objects.isNull(tagStatus)) {
            return null;
        }

        return ENUM_MAP.get(tagStatus);
    }

}
