package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-11 14:21
 */
@Getter
@AllArgsConstructor
public enum OtoCustMoneyEnum {

    UN_KNOW(0, "不详"),
    NO_MONEY(1, "无资金"),
    HAS_MONEY(2, "资金已到位"),
    LATER_HAS_MONEY(3, "资金近期到位"),
    NEXT_YEAR_HAS_MONEY(4, "资金明年到位");


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustMoneyEnum::getType, OtoCustMoneyEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }

    /**
     * 是否有强支付能力
     */
    public static boolean hasPayPower(Integer hasMoney) {
        return HAS_MONEY.getType().equals(hasMoney) || LATER_HAS_MONEY.getType().equals(hasMoney);
    }
}
