package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-11 14:14
 */
@Getter
@AllArgsConstructor
public enum OtoCustVisitOrgEnum {

    GUO_SHOU(0, "国寿"),
    TAI_KANG(1, "泰康"),
    TAI_PING(2, "太平"),
    OTHER(3, "其他");

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustVisitOrgEnum::getType, OtoCustVisitOrgEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByTypes(String types){
        if (StringUtils.isBlank(types)) {
            return null;
        }
        return Arrays.stream(types.split(",")).map(Integer::parseInt).map(ALL_MAP::get).collect(Collectors.joining(","));
    }
}
