package cn.com.duiba.oto.oto.service.api.remoteservice.dept;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.dept.DeptDto;
import cn.com.duiba.oto.dto.oto.dept.DeptSellerDto;
import cn.com.duiba.oto.param.oto.dept.DeptAddParam;
import cn.com.duiba.oto.param.oto.dept.DeptBatchAddSellerParam;
import cn.com.duiba.oto.param.oto.dept.DeptDelParam;
import cn.com.duiba.oto.param.oto.dept.DeptSellerPageParam;
import cn.com.duiba.oto.param.oto.dept.DeptUpdateParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-16 13:46
 */
@AdvancedFeignClient
public interface RemoteSellerDeptService {

    /**
     * 查看部门列表
     *
     * @return 部门列表
     */
    List<DeptDto> list();

    /**
     * 新增部门
     *
     * @return 是否成功
     */
    Boolean save(DeptAddParam deptAddParam) throws BizException;

    /**
     * 修改部门
     *
     * @return 是否成功
     */
    Boolean update(DeptUpdateParam deptUpdateParam) throws BizException;

    /**
     * 删除部门
     *
     * @return 是否成功
     */
    Boolean delete(DeptDelParam deptDelParam) throws BizException;

    /**
     * 批量设置部门成员
     *
     * @return 是否成功
     */
    Boolean batchAddSeller(DeptBatchAddSellerParam deptBatchAddSellerParam) throws BizException;

    /**
     * 查看部门下的成员列表
     *
     * @return 成员列表
     */
    DeptSellerDto listSellerByDeptId(DeptSellerPageParam deptSellerPageParam) throws BizException;

    /**
     * 根据销售id获取可以访问的数据sellerId的列表（数据权限使用）
     *
     * @param sellerId
     * @return
     */
    List<Long> authSellerIds(Long sellerId);

    /**
     * 根据销售id，获取该销售所绑定的部门id列表
     *
     * @param sellerId
     * @return
     */
    List<Long> deptList(Long sellerId);
}
