package cn.com.duiba.oto.oto.service.api.remoteservice.form.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.form.customer.PubFormCustomerDto;
import cn.com.duiba.oto.param.oto.customer.PubFormCustomerSearchParam;

import java.util.List;

/**
 * 公域引流-客户信息表 RPC接口
 *
 * @author xiaocong
 * @date 2021/11/16 10:46 下午
 */
@AdvancedFeignClient
public interface RemoterPubFormCustomerApiService {

    /**
     * 根据条件查询，分页
     *
     * @param param 查询条件
     * @return 公域引流-客户信息集合
     */
    List<PubFormCustomerDto> selectList(PubFormCustomerSearchParam param);


    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(PubFormCustomerSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 公域引流-客户信息
     */
    PubFormCustomerDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 公域引流-客户信息
     * @return 主键
     */
    Long insert(PubFormCustomerDto dto);

    /**
     * 更新
     *
     * @param dto 公域引流-客户信息
     * @return 执行结果
     */
    int update(PubFormCustomerDto dto);

    /**
     * 批量插入
     *
     * @param list 参数集合
     * @return dto集合
     */
    List<PubFormCustomerDto> batchInsert(List<PubFormCustomerDto> list);

    /**
     * 批量更新分发状态
     *
     * @param list 参数集合
     * @return 执行结果
     */
    int batchUpdateDistributeStatus(List<PubFormCustomerDto> list);

}
