package cn.com.duiba.oto.param.oto.seller;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 销售客户分配记录表
 * @author kjj mybatis generator 
 * @date 2022-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SellerAssignRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16475049713393663L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id, tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id, tb_oto_customer.id
     */
    private Long custId;

    /**
     * 分配类型,1=管理员分配,2=销售主动从投放池认领,3=销售主动从回收池认领,4=系统强制分配
     *  @see cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum
     */
    private Integer assignType;

}