/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class FormatUtils {
    private static final String REGEX_1 = "\\{\\{.*?\\}\\}";
    private static final String REGEX_2 = "\\{.*?\\}";

    private FormatUtils() {
    }

    public static String formatDoubleBrace(String template, Map<String, Object> params) {
        return FormatUtils.doFormat(template, params, REGEX_1, false);
    }

    public static String formatBrace(String template, Map<String, Object> params) {
        return FormatUtils.doFormat(template, params, REGEX_2, false);
    }

    private static String doFormat(String template, Map<String, Object> params, String regex1, boolean skip) {
        if (MapUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(regex1).matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            if (Objects.isNull(value) && skip) continue;
            m.appendReplacement(sb, value == null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]", "\n");
        message = message.replaceAll("\\[s\\]", " ");
        return message;
    }

    public static Map<String, String> formatString2Map(String source) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String oaIDPic : source.split(",")) {
            if (!oaIDPic.contains(":")) continue;
            String[] split = oaIDPic.split(":");
            map.put(split[0], split[1]);
        }
        return map;
    }
}

