package cn.com.duiba.oto.param.oto.seller;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * OTO-销售列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoSellerPageListParam extends PageQuery {

    private static final long serialVersionUID = -9206343841720838429L;

    /**
     * 销售手机号
     */
    private String phoneNumber;

    /**
     * 销售ID
     */
    private String sellerId;
    private List<Long> sellerIds;
    /**
     * 销售名称
     */
    private String sellerName;

    /**
     * 角色类型
     */
    private Integer roleType;

    /**
     * 销售所在地区
     */
    private String sellerArea;

    /**
     * 所属公司id
     */
    private Long companyId;

    /**
     * 销售等级,1=A,2=B,3=C
     */
    private Integer sellerLevel;

    /**
     * 工作状态,0-非工作中,1=工作中
     */
    private Integer workStatus;

    /**
     * 所属销售总监id
     */
    private Long sellerDirectorId;

    /**
     * 销售类型
     * @see cn.com.duiba.oto.enums.seller.SellerTypeEnum
     */
    private String sellerType;
    /**
     * tb_oto_user.id
     */
    private Long otoUserId;
    /**
     * 久久保模式 jjbFlag='orther_autarky'
     */
    private String jjbFlag;

    /**
     * 离职状态
     * @see cn.com.duiba.oto.enums.OtoSellerDimissionStatusEnum
     */
    private Integer dimissionStatus;

    /**
     * 部门ID集合
     */
    private List<Long> deptIds;
}
