package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author liuyj
 * @date 2022/8/5 09:59
 */
@Getter
@AllArgsConstructor
public enum InvitationEventTypeEnum {
    MODIFY_INVITATION_PHONE(1,"修改约面信息（电话）"),
    MODIFY_INVITATION_CUST_DETAIL(2, "修改约面信息（客户详情页）"),
    MODIFY_INVITATION_STATUS(3, "邀约状态切换"),
    ;

    private Integer code;

    private String desc;

    public static InvitationEventTypeEnum getByCode(Integer code) {
        for (InvitationEventTypeEnum invitationStatusEnum : InvitationEventTypeEnum.values()) {
            if (invitationStatusEnum.getCode().equals(code)) {
                return invitationStatusEnum;
            }
        }
        return null;
    }
}
