package cn.com.duiba.oto.enums.wx;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2023/1/28 15:16
 * @Description:
 */
public enum OtoUserExtTypeEnum {

    MP("mp", "小程序"),

    ;

    private String code;
    private String desc;

    OtoUserExtTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OtoUserExtTypeEnum of(String code) {
        if (code == null) {
            return null;
        }
        for (OtoUserExtTypeEnum typeEnum : OtoUserExtTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        throw new UnsupportedOperationException("不支持的ext类型");
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
