package cn.com.duiba.oto.dto.oto.wxwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 成员(销售)信息表
 * @author kjj mybatis generator 
 * @date 2022-10-08
 */
@Data
public class OtoInnerUserDto implements Serializable {
     
    private static final long serialVersionUID = 16652244080534587L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 成员(销售)UserID。对应管理端的帐号
     */
    private String userKey;

    /**
     * 成员（销售）名称
     */
    private String userName;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 成员所属部门id列表，仅返回该应用有查看权限的部门id
     */
    private String department;

    /**
     * 直属上级UserID，返回在应用可见范围内的直属上级列表，最多有五个直属上级；
     */
    private String directLeader;

    /**
     * 头像url
     */
    private String avatar;

    /**
     * 头像缩略图url
     */
    private String thumbAvatar;

    /**
     * 别名
     */
    private String alias;

    /**
     * 扩展属性
     */
    private String extattr;

    /**
     * 激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。已激活代表已激活企业微信或已关注微信插件（原企业号）。未激活代表既未激活企业微信又未关注微信插件（原企业号）。
     */
    private Integer status;

    /**
     * 员工个人二维码，扫描可添加为外部联系人(注意返回的是一个url，可在浏览器上打开该url以展示二维码)
     */
    private String qrCode;

    /**
     * 成员对外属性
     */
    private String externalProfile;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节
     */
    private String openUserid;

    /**
     * 主部门，仅当应用对主部门有查看权限时返回。
     */
    private Integer mainDepartment;

    /**
     * 部门内的排序值，默认为0。数量必须和department一致，数值越大排序越前面。值范围是[0, 2^32)
     */
    private String deptOrder;

    /**
     * 表示在所在的部门内是否为部门负责人。0-否；1-是。是一个列表，数量必须与department一致。
     */
    private String isLeaderInDept;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}