package cn.com.duiba.oto.oto.service.api.remoteservice.notification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.notification.NotificationRecordDTO;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordSaveParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordSearchParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordUpdateParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordUpdateUrlParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-05-26
 */
@AdvancedFeignClient
public interface RemoteOtoNotificationService {

    /**
     * 查询告知书信息，分页
     * @param param 查询条件
     * @return 告知书详情
     */
    PageResult<NotificationRecordDTO> list(NotificationRecordSearchParam param);

    /**
     * 告知书新增
     * @param param 新增的告知书信息
     * @return 保存结果
     */
    Boolean save(NotificationRecordSaveParam param);

    /**
     * 告知书编辑更新
     * @param param 更新的参数
     * @return 更新结果
     */
    Boolean update(NotificationRecordUpdateParam param);

    /**
     * 根据id获取
     * @param id 告知书主键
     * @return 告知书详情
     */
    NotificationRecordDTO getDetail(Long id);

    /**
     * 客户告知书签字提交
     * @param param 提交更新的信息
     * @return 更新结果
     */
    Boolean updateSignatureInfo(NotificationRecordUpdateUrlParam param);

    /**
     * 标记告知书失效
     * @param id id主键
     * @return 标记结果
     */
    Boolean signInvalid(Long id);

    /**
     * 校验投保单号是否存在，非已失效的投保单号是唯一的
     * @param insureOrder 投保单号
     * @param id 主键，save接口校验时为null，update接口校验时为主键
     * @return true-存在；false-不存在
     */
    Boolean checkInsureOrderExist(String insureOrder, Long id);
}
