package cn.com.duiba.oto.enums.wx;

import java.util.Objects;

/**
 * @author xiaotian
 */
public enum OtoOATypeEnum {

    MP(1, "主体小程序") {
        @Override
        public OtoUserExtTypeEnum change2ExtTypeEnum() {
            return OtoUserExtTypeEnum.MP;
        }
    };

    /**
     * 类型
     */
    private final Integer type;
    /**
     * 描述
     */
    private final String desc;

    OtoOATypeEnum(Integer type, String desc) {
        this.type = type;

        this.desc = desc;
    }

    public static OtoOATypeEnum typeOf(Integer type) {
        for (OtoOATypeEnum e : values()) {
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public abstract OtoUserExtTypeEnum change2ExtTypeEnum();

}
