package cn.com.duiba.oto.param.oto.interview;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-03-25
 */
@Data
public class InterviewFeedbackParam implements Serializable {
    /**
     * 登陆人ID
     */
    private Long loginId;

    /**
     * 面访备注
     */
    private String interviewRemark;

    /**
     * 面访主键ID
     */
    private Long id;

    /**
     * 客户阶流程组名称 0: 客户待分配 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交 5.已成单
     */
    private Integer custFlow;

    /**
     * 见面目的 1-1进2，2-2进3/2进4，3-3进，0-关系维护维护
     */
    private Integer custPhase;

    /** 核心决策人 */
    private String coreMaker;

    /** 客户关注度 */
    private Integer followWeight;

    /**
     * 出生年月日
     */
    private Date birthdayTime;

    /**
     * 客户居住地址
     */
    private String custAddress;

    /**
     * 客户觉得退休后到底要准备多少退休金才够用
     */
    private Integer pensionSalary;

    /**
     * 希望退休后每个月的养老生活费是多少
     */
    private Integer pensionCost;

    /**
     * 除了退休养老规划，还希望了解的有关家庭财富的板块有哪些
     */
    private String pensionOther;

    /**
     * 是否提交养老计划方案 0:否 1：是
     *  @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 计划书图片
     */
    private String planPicUrl;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品ID tb_product
     */
    private Long productId;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     */
    private Integer insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数 0默认为趸交
     */
    private Integer insPeriod;

    /**
     * 面访异常类型
     */
    private String unusualTypes;

    /**
     * 面访说明
     */
    private String unusualExplain;

    /**
     * 上传凭证
     */
    private String unusualProofs;

    /**
     * 是否是异常上传面访详情 false:否
     */
    private Boolean isNormal = true;

    /**
     * 是否可送计划书 0否 1是
     */
    private Integer giveProspectusFlag;

    /**
     * 计划书金额
     */
    private String prospectusAmount;

    /**
     * 计划书确认情况
     */
    private String prospectusDesc;

    /**
     * 陪同专家Id
     */
    private Long expertId;
}
