package cn.com.duiba.oto.enums.cust;

import java.util.Arrays;
import java.util.List;

/**
 * @author xiaotian
 * @date 2022/10/11 2:34 PM
 */
public enum CustParamKeyFactory {
    /**
     * 添加新key的时候确保不要跟之前的重复！！！！！！！！！！！！
     */
    OTO00001("headImage","客户头像"),
    OTO00002("considerAgedForWho","为谁考虑养老"),
    OTO00003("attentionOldCommunity","最关注养老社区什么"),
    OTO00004("talkForNext","下次见面聊什么"),
    OTO00005("nextMeetTime","下次见面时间"),
    OTO00006("finishPlanFlag","是否定稿计划书"),
    OTO00007("insuranceDemand","保险需求"),
    OTO00008("insuranceProducts","做什么产品"),
    OTO00009("insured","投/被保人"),
    OTO00010("insuranceAmount", "保险金额是多少"),
    OTO00011("drawType", "支取方案"),
    OTO00012("familyStructure", "家庭结构"),
    OTO00013("familyTies", "家庭关系"),
    OTO00014("occupationAndPension", "职业及退休金情况"),
    OTO00015("financialHabits", "平时理财习惯"),
    OTO00016("workingCapital", "手上有多少流动资金（大概）"),
    OTO00017("checkInCommunity", "是否需要入住社区"),
    OTO00018("otherDetails", "其它细节"),
    OTO00019("commitPlanFlag", "是否讲解计划书"),
    OTO00020("custManner", "客户态度"),
    OTO00021("rejectReason", "拒绝原因"),
    OTO00022("chanceReason", "机会原因"),
    OTO00023("inviteNextConnectTime", "下次联系日期"),
    OTO00024("doveDate", "鸽子时间"),
    OTO00025("rejectDate", "拒绝时间"),
    OTO00026("backDate", "退回时间"),
    OTO00027("viewRetireCommunity", "养老社区参观情况"),
    ;

    private static final String SPACE = "oto";
    private static final String SEPARATOR = "_";

    String key;

    String desc;

    CustParamKeyFactory(String key, String desc) {
        this.desc = desc;
        this.key = key;
    }

    @Override
    public String toString() {
        return SPACE + SEPARATOR + this.key;
    }


    public static List<String> getAllNewParam(){
        return Arrays.asList(CustParamKeyFactory.OTO00002.toString(),
                CustParamKeyFactory.OTO00003.toString(),
                CustParamKeyFactory.OTO00004.toString(),
                CustParamKeyFactory.OTO00005.toString(),
                CustParamKeyFactory.OTO00006.toString(),
                CustParamKeyFactory.OTO00007.toString(),
                CustParamKeyFactory.OTO00008.toString(),
                CustParamKeyFactory.OTO00009.toString(),
                CustParamKeyFactory.OTO00010.toString(),
                CustParamKeyFactory.OTO00011.toString(),
                CustParamKeyFactory.OTO00012.toString(),
                CustParamKeyFactory.OTO00013.toString(),
                CustParamKeyFactory.OTO00014.toString(),
                CustParamKeyFactory.OTO00015.toString(),
                CustParamKeyFactory.OTO00016.toString(),
                CustParamKeyFactory.OTO00017.toString(),
                CustParamKeyFactory.OTO00018.toString(),
                CustParamKeyFactory.OTO00019.toString(),
                CustParamKeyFactory.OTO00027.toString());
    }
}
