package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-29 13:52
 */
@AllArgsConstructor
@Getter
public enum CustSourceTypeEnum {

    COMMUNITY(1, "社区客户"),
    VX_VIDEO(2, "视频号客户"),
    CORP_WX(3, "企微客户"),
    ;

    /**
     * 客户类型
     */
    private final Integer type;

    /**
     * 客户描述
     */
    private final String desc;

    private static final Map<Integer, CustSourceTypeEnum> INNER_MAP = Arrays.stream(values()).collect(Collectors.toMap(CustSourceTypeEnum::getType, Function.identity(), (v1, v2) -> v1));

    public static CustSourceTypeEnum getByCode(String type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }
}
