package cn.com.duiba.oto.enums.cust.call;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 19:53
 */
@AllArgsConstructor
@Getter
public enum OtoCustomerCallTypeEnum {

    NORMAL(1, "normal", "普通来电"),
    DIALOUT(2, "dialout", "外呼通话"),
    TRANSFER(3, "transfer", "转接电话"),
    DIALTRANSFER(4, "dialtransfer", "外呼转接");


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 字段
     */
    private final String filed;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 字段状态Map
     */
    public static final Map<String, Integer> FIELD_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustomerCallTypeEnum::getFiled, OtoCustomerCallTypeEnum::getType)));

    /**
     * 根据字段获取状态
     */
    public static Integer getTypeByField(String field){
        if (StringUtils.isBlank(field)) {
            return null;
        }
        return FIELD_TYPE_MAP.get(field);
    }
}
