package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.OtoSellerRoleDto;

import java.util.List;

/**
 * OTO-成员角色信息
 *
 * @author xiaotian
 * @date 2022/9/19 5:59 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerRoleService {

    /**
     * 根据成员id获取角色
     * @param sellerIds
     * @return
     */
    List<OtoSellerRoleDto> selectBySellerIds(List<Long> sellerIds);


    /**
     * 删除成员角色
     * @param sellerId
     * @return
     */
    int deleteBySellerId(Long sellerId);


    /**
     * 删除成员角色
     * @param list
     * @return
     */
    int batchSave(List<OtoSellerRoleDto> list);

    /**
     * 根据角色获取成员id列表
     *
     * @param roleType
     * @see cn.com.duiba.oto.enums.SellerRoleEnum
     * @return
     */
    List<Long> getSellerByRoleType(Long roleType);
}
