package cn.com.duiba.oto.dto.oto.cust.init;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-20 16:56
 */
@Data
public class CustInitResultDTO implements Serializable {

    private static final long serialVersionUID = 8074256850491205739L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 初始化结果
     */
    private Boolean success;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 生成成功
     */
    public static CustInitResultDTO success(Long custId){
        CustInitResultDTO result = new CustInitResultDTO();
        result.setCustId(custId);
        result.setSuccess(true);
        return result;
    }

    /**
     * 生成失败
     */
    public static CustInitResultDTO failed(String message){
        CustInitResultDTO result = new CustInitResultDTO();
        result.setErrorMsg(message);
        result.setSuccess(false);
        return result;
    }
}
