package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.CustAssignCoefficientBean;
import cn.com.duiba.oto.dto.oto.seller.SellerAssignRecordDto;

import java.util.List;

/**
 * 销售客户分配记录
 * @author MeiChang
 * @Description
 */
@AdvancedFeignClient
public interface RemoteSellerAssignRecord {

    /**
     * 新增数据
     * @param recordDtoList
     * @return
     */
    boolean batchSave(List<SellerAssignRecordDto> recordDtoList);

    /**
     * 获取销售当日累计分配客户数量
     *
     * @param sellerId 销售ID
     * @param assignTypes 分配类型 {@link cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum}
     * @return 分配次数
     */
    Long sellerDailyAssignTimes(Long sellerId, List<Integer> assignTypes);

    /**
     * 获取客户当前系数
     * @param finalCustIds 客户id
     * @return 系数
     */
    List<CustAssignCoefficientBean> listLastCoefficient(List<Long> finalCustIds);

}
