/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CustSourceTypeEnum {
    COMMUNITY(1, "\u793e\u533a\u5ba2\u6237"),
    VX_VIDEO(2, "\u89c6\u9891\u53f7\u5ba2\u6237"),
    CORP_WX(3, "\u4f01\u5fae\u5ba2\u6237");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, CustSourceTypeEnum> INNER_MAP;

    public static CustSourceTypeEnum getByCode(String type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }

    private CustSourceTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Arrays.stream(CustSourceTypeEnum.values()).collect(Collectors.toMap(CustSourceTypeEnum::getType, Function.identity(), (v1, v2) -> v1));
    }
}

