package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustMeetRecordDto;
import cn.com.duiba.oto.param.oto.cust.cust.visit.CustMeetRecordSaveParam;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 15:08
 */
@AdvancedFeignClient
public interface RemoteCustMeetRecordService {

    /**
     * 根据销售id和客户id统计见面次数
     * @param otoSid 销售id
     * @param custId 客户id
     * @return 统计见面次数
     */
    long countBySidAndCustId(Long otoSid, Long custId);

    /**
     * 获取最近的一条见面记录
     * @param otoSid 销售id
     * @param custId 客户id
     * @return 统计见面次数
     */
    CustMeetRecordDto findLatest(Long otoSid, Long custId);

    /**
     * 面访客户记录保存
     *
     * @param param 面访参数
     * @return 面访记录保存
     */
    boolean meetCust(CustMeetRecordSaveParam param) throws BizException;

}
