package cn.com.duiba.oto.dto.oto.interview;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 移动端我的面访列表
 * @author xuanhongjian
 */
@Data
public class OtoCustomerInterviewDto implements Serializable {

    private static final long serialVersionUID = 3097615067308345810L;

    /**
     * 面访任务ID
     */
    private Long id;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 创建人id
     */
    private Long createId;

    /**
     * 面访场景配置ID 【tb_cust_interview_conf】
     */
    private Long interviewConfId;

    /**
     * 场景名称
     */
    private String sceneName;

    /**
     * 见面目的 1-1进2，2-2进3/2进4，3-3进，0-关系维护维护
     * @see cn.com.duiba.oto.enums.cust.OtoCustPhaseEnum
     */
    private Integer custPhase;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 面访类型
     * @see cn.com.duiba.oto.enums.interview.InterviewTypeEnum
     */
    private Integer interviewType;

    /**
     * 面访状态
     * @see cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum
     */
    private Integer interviewStatus;

    /**
     * 面访状态排序
     */
    private Integer interviewOrder;

    /**
     * 面访记录创建时间
     */
    private Date gmtCreate;

    /**
     * 面访预约时间
     */
    private Date appointmentTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OtoCustomerInterviewDto that = (OtoCustomerInterviewDto) o;
        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
