package cn.com.duiba.oto.oto.service.api.remoteservice.market;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoMarketActiviesDto;
import cn.com.duiba.oto.param.oto.cust.*;

import java.util.Date;
import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoMarketActivitiesService {

    /**
     * 新增营销活动
     * @param param
     * @return
     */
    OtoMarketActiviesDto save(OtoMarketActiviesSaveParam param);

    /**
     * 编辑营销活动
     * @param param
     * @return
     */
    boolean update(OtoMarketActiviesUpdateParam param);

    /**
     * 根据场景ID和行事历时间查询历史记录
     * @param sceneConfId 场景ID
     * @param maTimeStr 行事历时间
     * @return 结果
     */
    OtoMarketActiviesDto selectByTimeAndSceneId(Long sceneConfId, String maTimeStr, String timeInterval);

    /**
     * 根据场次ID删除
     * @param id 场次ID
     * @return 结果
     */
    Integer updateById(Long id);

    /**
     * 根据ID查询
     * @param id 业务ID
     * @return 结果
     */
    OtoMarketActiviesDto selectById(Long id);

    /**
     * 根据ID批量查询
     * @param ids 业务ID集合
     * @return 结果
     */
    List<OtoMarketActiviesDto> selectByIds(List<Long> ids);

    /**
     * 根据操作人查询
     * @param operatorIds 操作人集合
     * @param isNeedInvite 是否需要邀约
     * @return 结果
     */
    List<OtoMarketActiviesDto> selectByOperatorIds(List<Long> operatorIds, Integer isNeedInvite, Date startTime, Date endTime);

}
