package cn.com.duiba.oto.enums.push;


import java.util.Objects;

/**
 * 企微应用消息类型
 */
public enum WxAgentMessageTypeEnum {
    TEXT_CARD(1,"textcard","应用文字消息"),
    MARK_DOWN(2,"markdown","markdown消息"),
    ;
    /**
     * 系统定义code
     */
    private final Integer code;
    /**
     * 对应微信消息的type
     */
    private final String wxType;
    /**
     * 描述
     */
    private final String desc;

    WxAgentMessageTypeEnum(Integer code, String wxType, String desc) {
        this.code = code;
        this.wxType = wxType;
        this.desc = desc;
    }

    public String getWxType() {
        return wxType;
    }

    public final Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static WxAgentMessageTypeEnum getByCode(Integer code) {
        for (WxAgentMessageTypeEnum e :values())
            if (Objects.equals(code, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }

}
