package cn.com.duiba.oto.oto.service.api.remoteservice.oa;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.oa.OtoCustReportOaDto;
import cn.com.duiba.oto.dto.oto.oa.OtoCustReportOaRecordDto;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaRecordSaveParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaRecordSearchParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaSaveParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaSearchParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCustReportOaRecordService {

    /**
     * 新增审批
     */
    boolean save(OtoCustReportOaRecordSaveParam saveParam);

    /**
     * 删除审批
     * @param id 审批ID
     */
    boolean deleteById(Long id);

    /**
     * 根据条件查询审批记录
     * @param searchParam 条件参数
     */
    List<OtoCustReportOaRecordDto> obtainByParam(OtoCustReportOaRecordSearchParam searchParam);

    /**
     * 根据审批ID批量查询
     * @param oaIds 审批ID
     * @return 结果
     */
    List<OtoCustReportOaRecordDto> obtainByOaIds(List<Long> oaIds);
}
