package cn.com.duiba.oto.oto.service.api.remoteservice.oa;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.notification.NotificationRecordDTO;
import cn.com.duiba.oto.dto.oto.oa.OtoCustReportOaDto;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordSaveParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordSearchParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordUpdateParam;
import cn.com.duiba.oto.param.oto.notification.NotificationRecordUpdateUrlParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaSaveParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaSearchParam;
import cn.com.duiba.oto.param.oto.oa.OtoCustReportOaUpdateParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCustReportOaService {

    /**
     * 新增审批
     */
    boolean save(OtoCustReportOaSaveParam saveParam);

    /**
     * 编辑审批
     * @param updateParam 参数
     * @return 结果
     */
    boolean update(OtoCustReportOaUpdateParam updateParam);

    /**
     * 删除审批
     * @param id 审批ID
     */
    boolean deleteById(Long id);

    /**
     * 根据条件查询审批记录
     * @param searchParam 条件参数
     */
    List<OtoCustReportOaDto> obtainByParam(OtoCustReportOaSearchParam searchParam);

    /**
     * 分页查询
     * @param pageSearchParam 查询条件
     * @return 结果
     */
    Long pageCount(OtoCustReportOaSearchParam pageSearchParam);

    /**
     * 分页查询
     * @param pageSearchParam 查询条件
     * @return 结果
     */
    List<OtoCustReportOaDto> pageList(OtoCustReportOaSearchParam pageSearchParam);
}
