package cn.com.duiba.oto.param.oto.oa;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 客户报告审批表
 * @author kjj mybatis generator 
 * @date 2023-03-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustReportOaSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16797088382575685L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 客户id tb_oto_cust表主键id
     */
    private Long custId;

    private List<Long> custIds;

    private List<Long> expertIds;

    /**
     * 提交报告的专家/销售ID
     */
    private Long createId;

    /**
     * 提交报告人的当下角色
     */
    private Integer createRoleType;

    /**
     * 审批状态 1:待审批 2:审批通过 3:审批驳回 4:已上传方案
     */
    private Integer auditStatus;

    /**
     * 下一阶段待审批角色类型
     */
    private Integer nextRoleTypeOrder;

    /**
     * 下一阶段审批角色
     */
    private Integer nextRoleType;

    /**
     * 是否是当前客户最新的审批数据 0否 1是
     */
    private Integer newestRecord;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}