package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoDeptCustRefDto;
import cn.com.duiba.oto.param.oto.cust.OtoDeptCustRefSearchParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-16 10:00
 */
@AdvancedFeignClient
public interface RemoteDeptCustRefService {
    /**
     * 根据客户ID查询团队池
     * @param custIds 客户ID
     * @return 结果
     */
    List<OtoDeptCustRefDto> findByCustIds(List<Long> custIds);

    /**
     * 根据团队ID查询团队池
     * @param deptIds 团队ID
     * @return 结果
     */
    List<OtoDeptCustRefDto> findByDeptIds(List<Long> deptIds);

    /**
     * 根据客户ID删除
     * @param custId 客户ID
     * @return 结果
     */
    boolean deleteByCustId(Long custId);

    /**
     * 新增
     */
    boolean save(OtoDeptCustRefSearchParam param);
}
