package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 盘客户-计划执行表
 * @author kjj mybatis generator 
 * @date 2022-11-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustPlanSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16686646796583932L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 主键ids
     */
    private List<Long> ids;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 计划动作 phone:电话 meet:见面
     */
    private String planActionType;

    /**
     * 计划状态 1计划中 2已完成 3未完成
     */
    private Integer planStatus;

    /**
     * 行动人查询集合
     */
    List<Long> sellerIds;

    /**
     * 行动人（销售ID）tb_oto_seller主键ID
     */
    private Long actionSeller;

    /**
     * 行动时间
     */
    private Date actionTime;

    /**
     * 见面场景配置ID tb_interview_scene_conf主键ID
     */
    private Long interviewSceneConfId;

    /**
     * 盘客户表ID tb_oto_cust_check主键ID
     */
    private Long otoCustCheckId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 查询起始时间
     */
    private Date beginTime;

    /**
     * 查询截止时间
     */
    private Date endTime;
}