package cn.com.duiba.oto.dto.oto.wx.wxmessage.template;

import cn.com.duiba.oto.dto.oto.wx.wxmessage.BaseMessageDto;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * Created by xiaotian on 2020-02-07.
 * 模版消息
 */
@Data
public class TemplateMessageDto extends BaseMessageDto {
    private static final long serialVersionUID = -5035557323761812188L;
    /**
     * 模版消息ID
     */
    @NotBlank(message = "模版ID不能为空")
    private String templateId;
    /**
     * 模版消息体
     */
    @NotNull(message = "模版消息体不能为空")
    private JSONObject data;
    /**
     * 模版消息跳转的h5地址
     * 当跳转小程序时 次参数作为跳转失败的降级跳转。
     */
    private String url;
    /**
     * 跳转小程序时必须 小程序ID
     */
    private String mpAppId;
    /**
     *  小程序页面路由  跳转小程序时必须
     */
    private String mpPagePath;
}
