package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 见面目的
 *
 * @Author meichang
 * @Date 2022/5/18 19:53
 * @Version 1.0
 */
@AllArgsConstructor
@Getter
public enum OtoCustPhaseEnum {
    ONE_TO_TWO(1, "参观社区"),
    TWO_TO_THREE_OR_FOUR(2, "讲解方案"),
    THREE_TO_FOUR(3, "踢单"),
    KICK_THE_BILL(4, "财商沙龙"),
    NONE(0, "关系维护");


    /**
     * 编码
     */
    private final Integer code;

    /**
     * 备注
     */
    private final String desc;

    private static final Map<Integer, OtoCustPhaseEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustPhaseEnum::getCode, Function.identity(), (v1, v2)->v1)));;

    public static OtoCustPhaseEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
