package cn.com.duiba.oto.oto.service.api.remoteservice.callback;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.callback.ClueCallbackRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-07-20 17:11
 */
@AdvancedFeignClient
public interface RemoteClueCallbackRecordService {

    /**
     * 根据客户id获取回传记录
     * @param custIds 客户id
     * @return 回传记录
     */
    List<ClueCallbackRecordDto> listByCustIds(List<Long> custIds);

    /**
     * 保存回传记录
     * @param recordList 回传记录
     * @return 保存成功的数量
     */
    int batchSave(List<ClueCallbackRecordDto> recordList);

    /**
     * 统计申请赔付的数据
     * @param beginDate 开始日期
     * @return 申请赔付的数据数量
     */
    Long countCallbackNum(Date beginDate);
}
